
/********************************************************************************
If you should have any comments, suggestions or improvements to these samples,
we welcome you to contact us at SampleCode@melissadata.com also please visit our
developers bulletin board at forum.melissadata.com.
********************************************************************************/

using System;
using MelissaData;

namespace mdPhoneSample
{
    class Program
    {
    	  /********************** LICENSE STRINGS **********************
              To unlock the full function ality of Phone Object,   
           please call a sales representative at 1-800-MELISSA ext. 3 
                   (1-800-635-4772 x3) for a license string.          
              Without a valid license string, PhoneObject will     
                        only verify Nevada phone numbers.               
                       REPLACE "DEMO" with LICENSE STRING                    

          SetLicenseString will also check for a valid license in the 
          MDPHONE_LICENSE(Environment) variable. This allows you to  
          modify the license without recompiling the project 
        **************************************************************/ 
        public static String the_license = "DEMO";
        
        // ********************** DATA FILE PATH  ***********************
        //  File location path is set to the default Data File location
        //  Change this value if you installed the data files to a       
        //  different folder.                                            
        //  The Data Files Directory must contain the following files:   
        //  mdAddr.dat, mdPhone.dat, mdPhone.idx, and ZIPNPA.txt
        // **************************************************************
        
        public static String datafile_dir = "C:\\Program Files\\Melissa Data\\DQT\\Data";

        static void Main(string[] args)
        {
            mdPhone phoneObj = new mdPhone();

            phoneObj.SetLicenseString(the_license);
         
            if (phoneObj.Initialize(datafile_dir) != mdPhone.ProgramStatus.ErrorNone)
            {
                Console.WriteLine("Error initializing mdPhone: " + phoneObj.GetInitializeErrorString());
                Console.ReadLine();
                return;
            }

            //Get information about the object:
            Console.WriteLine("==========================================================");
            Console.WriteLine("               PHONE OBJECT NET EXAMPLE                   ");
            Console.WriteLine("                Build Number: " + phoneObj.GetBuildNumber());
            Console.WriteLine("               Database Date: " + phoneObj.GetDatabaseDate());
            Console.WriteLine("==========================================================");



            bool proceed = true;
            while (proceed)
            {
                //Get Phone and Verify
                
        Console.Write("Enter Telephone : ");
                String phone = Console.ReadLine();
                Console.Write("Enter Zip : ");
                String zip = Console.ReadLine();  

                phoneObj.Lookup(phone,zip);

          Console.WriteLine("\n==================Lookup Result===================\n");
      if(phoneObj.GetResults().Contains("PS01") || phoneObj.GetResults().Contains("PS02"))
      {
        if(phoneObj.GetResults().Contains("PS01"))
          Console.WriteLine("Phone validated to 10 digits");
        else if(phoneObj.GetResults().Contains("PS02"))
          Console.WriteLine("Phone validated to 7 digits");

        if(phoneObj.GetResults().Contains("PS07"))
          Console.WriteLine("Exchange Type: Cellular");
        else if(phoneObj.GetResults().Contains("PS08"))
          Console.WriteLine("Exchange Type: Land Line");
        else if(phoneObj.GetResults().Contains("PS09"))
          Console.WriteLine("Exchange Type: Voip");

        if(phoneObj.GetResults().Contains("PS10"))
          Console.WriteLine("Phone Type: Residential");
        else if(phoneObj.GetResults().Contains("PS11"))
          Console.WriteLine("Phone Type: Business");
        else if(phoneObj.GetResults().Contains("PS12"))
          Console.WriteLine("Phone Type: Small/Home Office");
  
        Console.WriteLine("\n======Wire Center Geographic Data======\n");
        Console.WriteLine("Latitude: " + phoneObj.GetLatitude());
        Console.WriteLine("Longitude: " + phoneObj.GetLongitude());
        Console.WriteLine("City: " + phoneObj.GetCity());
        Console.WriteLine("State: " + phoneObj.GetState());
        Console.WriteLine("County Name: " + phoneObj.GetCountyName());
        Console.WriteLine("County Fips: " + phoneObj.GetCountyFips());
        Console.WriteLine("Country Code: " + phoneObj.GetCountryCode());
        Console.WriteLine("Timezone: " + phoneObj.GetTimeZone());
        Console.WriteLine("Timezone Code: " + phoneObj.GetTimeZoneCode());

        if(phoneObj.GetResults().Contains("PS06"))
        {
          Console.WriteLine("\n======New Area Code ======\n");
          Console.WriteLine("Area Code: " + phoneObj.GetAreaCode());
          Console.WriteLine("New Area Code: " + phoneObj.GetNewAreaCode());
        }
      }
      else
      {
        if(phoneObj.GetResults().Contains("PE01"))
          Console.WriteLine("Bad Area Code");
        if(phoneObj.GetResults().Contains("PE02"))
          Console.WriteLine("Blank Phone Number");
        if(phoneObj.GetResults().Contains("PE03"))
          Console.WriteLine("Too few or too many digits");
        if(phoneObj.GetResults().Contains("PE04"))
          Console.WriteLine("Multiple Match");
        if(phoneObj.GetResults().Contains("PE05"))
          Console.WriteLine("Bad prefix");
        if(phoneObj.GetResults().Contains("PE06"))
          Console.WriteLine("Bad Zip Code");

      }
                    
                Console.Write("Enter X to quit:");
                string quit = Console.ReadLine();
                if (quit.ToUpper().Trim() == "X")
                {
                    proceed = false;
                }
            }

            phoneObj.Dispose();
        }
    }
}
